/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.util;

import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.excepciones.ExcepcionCatalogoNoEncontrado;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidadorCompensaciones
implements Serializable {
    private static final long serialVersionUID = 846211274528855228L;

    public void validarCompensaciones(ResultadoValidacion resultado, String baseImponible, List<Compensacion> compensaciones, Periodo periodo) {
        BigDecimal valorCalculado;
        boolean existenCompensaciones = false;
        BigDecimal totalCompensaciones = BigDecimal.ZERO;
        for (Compensacion compensacion : compensaciones) {
            existenCompensaciones = true;
            if (this.validarFormatoDeMontoDeCompensacion(compensacion.getMonto())) {
                totalCompensaciones = totalCompensaciones.add(Util.getBigDecimal(compensacion.getMonto()));
                continue;
            }
            resultado.fallarValidacion("El monto de compensaci\u00f3n " + compensacion.getDescripcionCompensacion() + " debe ser 12 enteros y 2 decimales. ");
        }
        if (existenCompensaciones && totalCompensaciones.compareTo(valorCalculado = Util.getPorcentaje(Util.getBigDecimal(baseImponible), this.obtenerPorcentajeCalculoPorPeriodo(periodo))) != 0) {
            resultado.pasarValidacionAdvertencia("El valor de compensaciones es diferente al valor calculado por el sistema: " + valorCalculado);
        }
    }

    private boolean validarFormatoDeMontoDeCompensacion(String montoCompensacion) {
        Pattern patronMonto = Pattern.compile("^[0-9]{1,12}(((?=\\.)\\.[0-9]{2}$)|($))");
        Matcher matcher = patronMonto.matcher(montoCompensacion);
        return matcher.matches();
    }

    private BigDecimal obtenerPorcentajeCalculoPorPeriodo(Periodo periodo) {
        Map porcentajes = UtilCatalogosATS.crearInstancia().obtenerPorcentajeCompensacionesPorPeriodo(periodo.getFechaDeclarada());
        BigDecimal porcentaje = BigDecimal.ZERO;
        if (porcentajes.size() > 1) {
            throw new ExcepcionCatalogoNoEncontrado("No se ha podido cargar el porcentaje de compensacion");
        }
        for (Map.Entry porcentajeCompensacion : porcentajes.entrySet()) {
            porcentaje = (BigDecimal)((AbstractMap.SimpleEntry)porcentajeCompensacion.getValue()).getValue();
        }
        return porcentaje;
    }
}

